unit Common;

interface

type
	TErrorCode = (
                     ecNoError,
                     ecUnknownError,
                     ecSyntaxError,
                     ecExceedsLine,
                     ecVarIdentExpected,
                     ecIdentExpected,
                     ecAssignExpected,
                     ecConstExpected,
                     ecUnknownIdent,
                     ecEndOfFile,
                     ecDupIdent,
                     ecWrongType,
                     ecLBExpected,
                     ecRBExpected,
                     ecOpenComment,
                     ecExpressionError,
                     ecEndExpected,
                     ecVarExpected,
                     ecToExpected,
                     ecLPExpected,
                     ecRPExpected,
                     ecStrConstExpected,
                     ecBreakError,
                     ecNextError
                     );

const
  CaseSensetive = True;
  Line: Word = 1;
  Column: Word = 1;
  SaveLine: Word = 1;
  SaveColumn: Word = 1;


var
  SourceFileName: string[12];
  DestFileName: string[12];
  SourceFile: file of Char;
  DestFile, VarFile: Text;

procedure Error(Code:TErrorCode);
procedure Warning(Code:TErrorCode);

implementation

uses Dos;

const
  ErrorMessage: array[TErrorCode] of PChar = (
                'No errors',
                'Unknown error',
                'Syntax error',
                'String constant exceeds line',
                'Variable identifier expected',
                'Identifier expected',
                '''='' expected',
                'Constant expression expected',
                'Unknown identifier',
                'Unexpected end of file',
                'Duplicate identifier',
                'Wrong type',
                'Left bracket expected',
                'Right bracket expected',
                'Comment not closed',
                'Error in expression',
                '''End'' expected',
                'Variable expected',
                '''To'' expected',
                'Left parent expected',
                'Right parent expected',
                'String constant expected',
                '''Break'' can be used in cycle statement only',
                '''Next'' can be used in cycle statement only'
                );

var
  Dir: string[1];
  Name: NameStr;
  Ext: ExtStr;

procedure Error(Code:TErrorCode);
begin
  Close(SourceFile);
  Close(DestFile);
  Close(VarFile);
  Write('Error: ', ErrorMessage[Code]);
  WriteLn(' at line (', SaveLine, '), column (', SaveColumn, ') in file: (',SourceFileName, ')');
  Halt(Byte(Code));
end;

procedure Warning(Code:TErrorCode);
begin
  Write('Warning: ', ErrorMessage[Code]);
  WriteLn(' at line (', SaveLine, '), column (', SaveColumn, ') in file: (',SourceFileName, ')');
end;

begin
  if ParamCount <> 1 then begin
    WriteLn('Format: Compiler.Exe <SourceFileName.Ext>');
    Halt;
  end;
  SourceFileName := ParamStr(1);
  Assign(SourceFile, SourceFileName);
  Reset(SourceFile);
  if IOResult <> 0 then begin
    WriteLn('Source file open error');
    Halt;
  end;
  FSplit(ParamStr(1), Dir, Name, Ext);
  DestFileName := Name + '.asm';
  Assign(DestFile, DestFileName);
  Rewrite(DestFile);
  Assign(VarFile, 'var.asm');
  Rewrite(VarFile);
end.